/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.teastory.block.craft;

import cloud.lemonslice.teastory.block.craft.IStoveBlock;
import cloud.lemonslice.teastory.blockentity.StoveBlockEntity;
import cloud.lemonslice.teastory.helper.VoxelShapeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;
import xueluoanping.teastory.block.NormalHorizontalBlock;
import xueluoanping.teastory.registry.BlockEntityRegister;

public class StoveBlock
extends NormalHorizontalBlock
implements IStoveBlock,
EntityBlock {
    protected int efficiency;
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    private static final VoxelShape SHAPE;

    public StoveBlock(BlockBehaviour.Properties properties, int efficiency) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
        this.efficiency = efficiency;
    }

    @Override
    public int getFuelPower() {
        return this.efficiency;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{LIT}));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void m_214162_(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        if (IStoveBlock.isBurning(stateIn)) {
            double d0 = (double)pos.m_123341_() + 0.5;
            double d1 = (double)pos.m_123342_() + rand.m_188500_() * 6.0 / 16.0;
            double d2 = (double)pos.m_123343_() + 0.5;
            BlockEntity te = worldIn.m_7702_(pos);
            te.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.DOWN).ifPresent(inv -> {
                int ash = inv.getStackInSlot(0).m_41613_();
                if (ash < 32) {
                    for (i = 0; i < ash / 4 + 1; ++i) {
                        double d4 = rand.m_188500_() * 0.6 - 0.3;
                        worldIn.m_6493_((ParticleOptions)ParticleTypes.f_123762_, false, d0 + d4, d1 + 1.0, d2 + d4, 0.0, 0.1, 0.0);
                    }
                } else {
                    for (i = 0; i < ash / 5; ++i) {
                        double d4 = rand.m_188500_() * 0.6 - 0.3;
                        worldIn.m_6493_((ParticleOptions)ParticleTypes.f_123755_, false, d0 + d4, d1 + 1.0, d2 + d4, 0.0, 0.1, 0.0);
                    }
                }
                double d4 = rand.m_188500_() * 0.6 - 0.3;
                worldIn.m_6493_((ParticleOptions)ParticleTypes.f_123744_, false, d0 + d4, d1, d2 + d4, 0.0, 0.06, 0.0);
            });
        }
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity te = worldIn.m_7702_(pos);
        Item held = player.m_21120_(handIn).m_41720_();
        if (held == BlockEntityRegister.BAMBOO_TRAY_ITEM.get() || held == BlockEntityRegister.IRON_KETTLE_ITEM.get()) {
            return InteractionResult.PASS;
        }
        if (te instanceof StoveBlockEntity) {
            if (player.m_6144_()) {
                if (!worldIn.m_5776_()) {
                    NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)((MenuProvider)te), (BlockPos)te.m_58899_());
                }
                return InteractionResult.SUCCESS;
            }
            if (held.equals(Items.f_42409_)) {
                ((StoveBlockEntity)te).setToLit();
                player.m_21120_(handIn).m_41622_(1, (LivingEntity)player, onBroken -> onBroken.m_21190_(handIn));
                worldIn.m_5594_(player, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, worldIn.m_213780_().m_188501_() * 0.4f + 0.8f);
                return InteractionResult.SUCCESS;
            }
            if (held.equals(Items.f_42613_)) {
                ((StoveBlockEntity)te).setToLit();
                player.m_21120_(handIn).m_41774_(1);
                return InteractionResult.SUCCESS;
            }
            if (ForgeHooks.getBurnTime((ItemStack)player.m_21120_(handIn), (RecipeType)RecipeType.f_44108_) > 0) {
                te.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.UP).ifPresent(fuel -> {
                    player.m_21008_(handIn, fuel.insertItem(0, player.m_21120_(handIn), false));
                    te.m_6596_();
                });
                return InteractionResult.SUCCESS;
            }
            if (((StoveBlockEntity)te).isDoubleClick()) {
                this.dropFuel(worldIn, pos);
                return InteractionResult.SUCCESS;
            }
            this.dropAsh(worldIn, pos);
            if (!worldIn.m_5776_()) {
                ((StoveBlockEntity)te).singleClickStart();
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    private void dropAsh(Level worldIn, BlockPos pos) {
        BlockEntity te = worldIn.m_7702_(pos);
        if (te != null) {
            te.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.DOWN).ifPresent(ash -> {
                for (int i = ash.getSlots() - 1; i >= 0; --i) {
                    if (ash.getStackInSlot(i) == ItemStack.f_41583_) continue;
                    Block.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)ash.getStackInSlot(i));
                    ((IItemHandlerModifiable)ash).setStackInSlot(i, ItemStack.f_41583_);
                }
            });
        }
    }

    private void dropFuel(Level worldIn, BlockPos pos) {
        BlockEntity te = worldIn.m_7702_(pos);
        if (te != null) {
            te.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.UP).ifPresent(fuel -> {
                for (int i = fuel.getSlots() - 1; i >= 0; --i) {
                    if (fuel.getStackInSlot(i) == ItemStack.f_41583_) continue;
                    Block.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)fuel.getStackInSlot(i));
                    ((IItemHandlerModifiable)fuel).setStackInSlot(i, ItemStack.f_41583_);
                }
            });
        }
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pos, BlockState pNewState, boolean isMoving) {
        if (!pNewState.m_60713_((Block)this)) {
            this.dropFuel(pLevel, pos);
            this.dropAsh(pLevel, pos);
        }
        super.m_6810_(pState, pLevel, pos, pNewState, isMoving);
    }

    public static void setState(boolean active, Level worldIn, BlockPos pos) {
        BlockState iblockstate = worldIn.m_8055_(pos);
        BlockEntity tileentity = worldIn.m_7702_(pos);
        if (active) {
            worldIn.m_46597_(pos, (BlockState)((BlockState)iblockstate.m_61124_((Property)f_54117_, (Comparable)((Direction)iblockstate.m_61143_((Property)f_54117_)))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true)));
        } else {
            worldIn.m_46597_(pos, (BlockState)((BlockState)iblockstate.m_61124_((Property)f_54117_, (Comparable)((Direction)iblockstate.m_61143_((Property)f_54117_)))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
        }
        if (tileentity != null) {
            tileentity.invalidateCaps();
            worldIn.m_151523_(tileentity);
        }
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof LivingEntity && !entityIn.m_6060_() && IStoveBlock.isBurning(worldIn, pos) && !EnchantmentHelper.m_44938_((LivingEntity)((LivingEntity)entityIn))) {
            if (worldIn.m_213780_().m_188499_()) {
                entityIn.m_6469_(entityIn.m_269291_().m_269387_(), 1.0f);
            }
            ((LivingEntity)entityIn).m_7292_(new MobEffectInstance(MobEffects.f_19610_, 60));
        }
        super.m_7892_(state, worldIn, pos, entityIn);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos p_153215_, BlockState p_153216_) {
        return new StoveBlockEntity(p_153215_, p_153216_);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level worldIn, BlockState state, BlockEntityType<T> blockEntityType) {
        return !worldIn.f_46443_ ? NormalHorizontalBlock.createTickerHelper(blockEntityType, (BlockEntityType)BlockEntityRegister.STOVE_TYPE.get(), StoveBlockEntity::tick) : null;
    }

    static {
        VoxelShape top = VoxelShapeHelper.createVoxelShape(0.0, 14.0, 0.0, 16.0, 2.0, 16.0);
        VoxelShape body = VoxelShapeHelper.createVoxelShape(1.0, 0.0, 1.0, 14.0, 16.0, 14.0);
        SHAPE = Shapes.m_83110_((VoxelShape)top, (VoxelShape)body);
    }
}

